% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{un_votes}
\alias{un_votes}
\title{United Nations General Assembly voting data by country and roll call}
\format{A data frame (specifically a tbl_df) with one row
for each country-vote pair, and the following columns:
\describe{
  \item{rcid}{The roll call id; used to join with \code{\link{un_roll_calls}}
  and \code{\link{un_roll_call_issues}}}
  \item{country}{Country name, by official English short name}
  \item{country_code}{2-character ISO country code}
  \item{vote}{Vote result as a factor of yes/abstain/no}
}}
\source{
Erik Voeten "Data and Analyses of Voting in the UN General Assembly"
 Routledge Handbook of International Organization, edited by Bob Reinalda
  (published May 27, 2013)
  \url{https://dataverse.harvard.edu/dataset.xhtml?persistentId=hdl:1902.1/12379}
}
\usage{
un_votes
}
\description{
Information on the voting history of the United Nations General Assembly.
Contains one row for each country-vote pair.
}
\details{
The original data included cases where a country was absent
or was not yet a member. In this dataset these were filtered out to
include only votes of Yes, Abstain, and No.

Country name can be converted to other unique country identifiers
(such as 2-character or 3-character ISO codes) using the
\link[countrycode]{countrycode} function from the countrycode
package.
}
\examples{

library(dplyr)

# percentage yes by country
by_country <- un_votes \%>\%
  group_by(country) \%>\%
  summarize(votes = n(),
            percent_yes = mean(vote == 1))

arrange(by_country, percent_yes)
arrange(by_country, desc(percent_yes))

# combine with per-vote information
un_votes \%>\%
  inner_join(un_roll_calls, by = "rcid")

# combine with issue
votes_issues <- un_votes \%>\%
  inner_join(un_roll_call_issues, by = "rcid")

# for example, which countries voted yes least often on Colonialism
votes_issues \%>\%
  filter(issue == "Colonialism") \%>\%
  group_by(country) \%>\%
  summarize(percent_yes = mean(vote == 1)) \%>\%
  arrange(percent_yes)

}
\keyword{datasets}
