% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_hyper_weights}
\alias{get_hyper_weights}
\title{Return mixture weights needed to obtain a hypergeometric
distribution.}
\usage{
get_hyper_weights(ploidy, ell)
}
\arguments{
\item{ploidy}{The ploidy of the individual.}

\item{ell}{The number of reference alleles in the individual.}
}
\value{
A list with the following two elements:
\describe{
\item{\code{pmat}}{Reach row is a category and the columns
    index either aa, Aa, or AA.}
\item{\code{weightvec}}{The mixing weights for each row of pmat.}
}
}
\description{
Obtains the mixing weights for the mixing distributions
of \code{\link{get_bivalent_probs}} to return a hypergeometric
distribution where \code{ploidy} is the population size,
\code{ell} is the number of success states in the population,
and \code{ploidy / 2} is the number of draws. If these
are the mixing weights in the population, then there is no
preferential pairing.
}
\examples{
get_hyper_weights(4, 2)

}
\author{
David Gerard
}
