% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_linksMetrics.R
\name{bitly_LinksMetricsEncoders}
\alias{bitly_LinksMetricsEncoders}
\title{Returns users who have encoded this long URL.}
\usage{
bitly_LinksMetricsEncoders(link, my_network = "false", limit = 25,
  expand_user = "false", subaccounts = "false", showRequestURL = FALSE)
}
\arguments{
\item{link}{- a Bitlink.}

\item{my_network}{- true or false (default) restrict to my network.}

\item{limit}{- 1 to 1000 (default=1000).}

\item{expand_user}{- true or false (default) include display names of encoders.}

\item{subaccounts}{- (only available to enterprise accounts) false (always default) restrict to 
this enterprise account and its subaccounts}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
entries - a mapping of link, user, and ts (when the Bitlink was created) and possible 
more depending on input parameters.
}
\description{
Returns users who have encoded this long URL (optionally only those in 
the requesting user's social graph).
}
\note{
Some users may not be returned from this call depending on Bitlink privacy settings.
}
\examples{
\dontrun{
bitly_token <- bitly_auth(key = "", secret = "")
bitly_LinksMetricsEncoders(link = "http://bit.ly/DPetrov")
bitly_LinksMetricsEncoders("http://bit.ly/DPetrov", expand_user = "true", my_network = "false")
}

}
\seealso{
\url{http://dev.bitly.com/link_metrics.html#v3_link_encoders}
}

