% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issue.R
\name{issue-this}
\alias{issue-this}
\alias{issue_close_community}
\alias{issue_reprex_needed}
\title{Helpers for GitHub issues}
\usage{
issue_close_community(number, reprex = FALSE)

issue_reprex_needed(number)
}
\arguments{
\item{number}{Issue number}

\item{reprex}{Does the issue also need a reprex?}
}
\description{
The \verb{issue_*} family of functions allows you to perform common operations on
GitHub issues from within R. They're designed to help you efficiently deal
with large numbers of issues, particularly motivated by the challenges faced
by the tidyverse team.
\itemize{
\item \code{issue_close_community()} closes an issue, because it's not a bug report or
feature request, and points the author towards RStudio Community as a
better place to discuss usage (\url{https://community.rstudio.com}).
\item \code{issue_reprex_needed()} labels the issue with the "reprex" label and
gives the author some advice about what is needed.
}
}
\section{Saved replies}{


Unlike GitHub's "saved replies", these functions can:
\itemize{
\item Be shared between people
\item Perform other actions, like labelling, or closing
\item Have additional arguments
\item Include randomness (like friendly gifs)
}
}

\examples{
\dontrun{
issue_close_community(12)

issue_reprex_needed(241, reprex = TRUE)
}
}
