% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-actions.R, R/tidyverse.R, R/upkeep.R
\name{use_tidy_github_actions}
\alias{use_tidy_github_actions}
\alias{tidyverse}
\alias{create_tidy_package}
\alias{use_tidy_description}
\alias{use_tidy_dependencies}
\alias{use_tidy_contributing}
\alias{use_tidy_support}
\alias{use_tidy_issue_template}
\alias{use_tidy_coc}
\alias{use_tidy_github}
\alias{use_tidy_style}
\alias{use_tidy_logo}
\alias{use_tidy_upkeep_issue}
\title{Helpers for tidyverse development}
\usage{
use_tidy_github_actions(ref = NULL)

create_tidy_package(path, copyright_holder = NULL)

use_tidy_description()

use_tidy_dependencies()

use_tidy_contributing()

use_tidy_support()

use_tidy_issue_template()

use_tidy_coc()

use_tidy_github()

use_tidy_style(strict = TRUE)

use_tidy_logo(geometry = "240x278", retina = TRUE)

use_tidy_upkeep_issue(year = NULL)
}
\arguments{
\item{ref}{Desired Git reference, usually the name of a tag (\code{"v2"}) or
branch (\code{"main"}). Other possibilities include a commit SHA (\code{"d1c516d"})
or \code{"HEAD"} (meaning "tip of remote's default branch"). If not specified,
defaults to the latest published release of \code{r-lib/actions}
(\url{https://github.com/r-lib/actions/releases}).}

\item{path}{A path. If it exists, it is used. If it does not exist, it is
created, provided that the parent path exists.}

\item{copyright_holder}{Name of the copyright holder or holders. This
defaults to "{package name} authors"; you should only change this if you
use a CLA to assign copyright to a single entity.}

\item{strict}{Boolean indicating whether or not a strict version of styling
should be applied. See \code{\link[styler:tidyverse_style]{styler::tidyverse_style()}} for details.}

\item{geometry}{a \link[magick:geometry]{magick::geometry} string specifying size. The default
assumes that you have a hex logo using spec from
\url{http://hexb.in/sticker.html}.}

\item{retina}{\code{TRUE}, the default, scales the image on the README,
assuming that geometry is double the desired size.}

\item{year}{Approximate year when you last touched this package. If \code{NULL},
the default, will give you a full set of actions to perform.}
}
\description{
These helpers follow tidyverse conventions which are generally a little
stricter than the defaults, reflecting the need for greater rigor in
commonly used packages.
}
\details{
\itemize{
\item \code{use_tidy_github_actions()}: Sets up the following workflows using \href{https://github.com/features/actions}{GitHub Actions}:
\itemize{
\item Run \verb{R CMD check} on the current release, devel, and four previous
versions of R. The build matrix also ensures \verb{R CMD check} is run at
least once on each of the three major operating systems (Linux, macOS,
and Windows).
\item Report test coverage.
\item Build and deploy a pkgdown site.
\item Provide two commands to be used in pull requests: \verb{/document} to run
\code{roxygen2::roxygenise()} and update the PR, and \verb{/style} to run
\code{styler::style_pkg()} and update the PR.

This is how the tidyverse team checks its packages, but it is overkill
for less widely used packages. Consider using the more streamlined
workflows set up by \code{\link[=use_github_actions]{use_github_actions()}} or
\code{\link[=use_github_action_check_standard]{use_github_action_check_standard()}}.
}
}

\itemize{
\item \code{create_tidy_package()}: creates a new package, immediately applies as many
of the tidyverse conventions as possible, issues a few reminders, and
activates the new package.
\item \code{use_tidy_dependencies()}: sets up standard dependencies used by all
tidyverse packages (except packages that are designed to be dependency free).
\item \code{use_tidy_description()}: puts fields in standard order and alphabetises
dependencies.
\item \code{use_tidy_eval()}: imports a standard set of helpers to facilitate
programming with the tidy eval toolkit.
\item \code{use_tidy_style()}: styles source code according to the \href{https://style.tidyverse.org}{tidyverse style guide}. This function will overwrite files! See
below for usage advice.
\item \code{use_tidy_contributing()}: adds standard tidyverse contributing guidelines.
\item \code{use_tidy_issue_template()}: adds a standard tidyverse issue template.
\item \code{use_tidy_release_test_env()}: updates the test environment section in
\code{cran-comments.md}.
\item \code{use_tidy_support()}: adds a standard description of support resources for
the tidyverse.
\item \code{use_tidy_coc()}: equivalent to \code{use_code_of_conduct()}, but puts the
document in a \verb{.github/} subdirectory.
\item \code{use_tidy_github()}: convenience wrapper that calls
\code{use_tidy_contributing()}, \code{use_tidy_issue_template()}, \code{use_tidy_support()},
\code{use_tidy_coc()}.
\item \code{\link[=use_tidy_github_labels]{use_tidy_github_labels()}} calls \code{use_github_labels()} to implement
tidyverse conventions around GitHub issue label names and colours.
\item \code{use_tidy_upkeep_issue()} creates an issue containing a checklist of
actions to bring your package up to current tidyverse standards.
\item \code{use_tidy_logo()} calls \code{use_logo()} on the appropriate hex sticker PNG
file at \url{https://github.com/rstudio/hex-stickers}.
}
}
\section{\code{use_tidy_style()}}{

Uses the \href{https://styler.r-lib.org}{styler package} package to style all code
in a package, project, or directory, according to the \href{https://style.tidyverse.org}{tidyverse style guide}.

\strong{Warning:} This function will overwrite files! It is strongly suggested to
only style files that are under version control or to first create a backup
copy.

Invisibly returns a data frame with one row per file, that indicates whether
styling caused a change.
}

