% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns.R
\name{get_optim_fit}
\alias{get_optim_fit}
\title{Fit model to data using optim}
\usage{
get_optim_fit(initial_params, param_names, free_param_index, data,
  model_list = "four",
  forward_param_transform_fn = forward_param_transform_fn,
  inv_param_transform_fn = inv_param_transform_fn, searchmethod)
}
\arguments{
\item{initial_params}{named vector of the initial parameter guess.}

\item{param_names}{names of parameter vector.}

\item{free_param_index}{logical vector indicating whether the parameters A, delta, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE) for the biphasic model and c(FALSE, FALSE, TRUE, TRUE) for the single phase model.}

\item{data}{dataframe with columns for the subject's viral load measurements ('vl'), and timing of sampling ('time')}

\item{model_list}{character indicating which model is begin fit. Can be either 'four' for the biphasic model, or 'two' for the single phase model. Defaults to 'four'.}

\item{forward_param_transform_fn}{list of transformation functions to be used when fitting the model in optim. Defaults to log transformations for all parameters (to allow unconstrained optimization).}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}

\item{searchmethod}{optimization algorithm to be used in optim. Defaults to Nelder-Mead.}
}
\description{
This function uses optim to fit either the biphasic or single phase model to data from a given subject
}
