% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fns.R
\name{get_singlephase}
\alias{get_singlephase}
\title{Compute the single phase model curve}
\usage{
get_singlephase(params, timevec)
}
\arguments{
\item{params}{named numeric vector of all parameters needed to compute the single phase model, V(t)}

\item{timevec}{numeric vector of the times, t, at which V(t) should be calculated}
}
\value{
numeric vector of viral load predictions, V(t), for each time point in 'timevec'
}
\description{
This function calculates the single phase model, V(t), for vector of input times, t
}
\examples{

get_singlephase(params = c(B = 1000, gamma = 0.68), timevec = seq(1, 100, length.out = 100))

}
