% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns_triphasic.R
\name{fit_model_triphasic}
\alias{fit_model_triphasic}
\title{Fit model and obtain parameter estimates}
\usage{
fit_model_triphasic(data, id_vector, param_names, initial_params,
  free_param_index, n_min_triphasic, forward_param_transform_fn,
  inv_param_transform_fn, searchmethod)
}
\arguments{
\item{data}{dataframe with columns for each subject's identifier ('id'), viral load measurements ('vl'), and timing of sampling ('time')}

\item{id_vector}{vector of identifiers corresponding to the subjects to be fitted.}

\item{param_names}{names of parameter vector.}

\item{initial_params}{named vector of the initial parameter guess.}

\item{free_param_index}{logical vector indicating whether the parameters A, delta, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE) for the biphasic model and c(FALSE, FALSE, TRUE, TRUE) for the single phase model.}

\item{n_min_triphasic}{the minimum number of data points required to fit the triphasic model.}

\item{forward_param_transform_fn}{list of transformation functions to be used when fitting the model in optim. Defaults to log transformations for all parameters (to allow unconstrained optimization).}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}

\item{searchmethod}{optimization algorithm to be used in optim. Defaults to Nelder-Mead.}
}
\description{
This function fits the triphasic model to the processed data and extracts the best-fit parameters.
}
