% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd_endpoints.R
\name{ustfd_datasets}
\alias{ustfd_datasets}
\title{Return a table of supported and known datasets}
\source{
\url{https://fiscaldata.treasury.gov/api-documentation/#list-of-endpoints}
}
\usage{
ustfd_datasets()
}
\value{
tibble
}
\description{
\code{ustfd_datasets} provides details about 34 known datasets for Fiscal Data.
A data frame with 34 rows and the following 7 columns:
\itemize{
\item \code{dataset} - ID of the source dataset (natural key)
\item \code{name} - name of the source dataset
\item \code{summary_text} - description of the data set and the data it covers
\item \code{earliest_date} - the date of the earliest record available for this table
\item \code{data_start_year} - first year in the data set
\item \code{update_frequency} - "Daily", "Monthly", "Quarterly", "Semi-Annually",
"Annually", "As Needed", "Daily (Discontinued)", "Monthly (Discontinued)"
\item \code{notes_and_known_limitations} - notes about
}
}
\examples{
library(ustfd)
ustfd_datasets()



}
\seealso{
Other ustfd_user: 
\code{\link{endpoint_exists}()},
\code{\link{ustfd_all_pages}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_simple}()},
\code{\link{ustfd_table_columns}()},
\code{\link{ustfd_tables}()}
}
\concept{ustfd_user}
