% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_event_row.R
\name{build_event_row_}
\alias{build_event_row_}
\title{build_event_row_}
\usage{
build_event_row_(fit, data, percent.sign, digits, p.digits, indent)
}
\arguments{
\item{fit}{Required. Formula, survival::survfit(), survival::coxph(). The formula
must contain a survival::Surv() object as first term. All terms must be present in data.}

\item{data}{Semi-optional. Tibble. Contains data for time-to-event model. Only required
if \'fit\' is a formula.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round numerics to. Defaults to 1.}

\item{p.digits}{Optional. Integer. Number of digits to print for p-values. Note that p-values are
still rounded based on \'digits\' parameter. Defaults to 4.}

\item{indent}{Optional. Logical. Indent a variable labels. Defaults to FALSE.}
}
\value{
A custom build_event_row() function. See related documentation for behavior.
}
\description{
A factory for creating a copy of build_event_row() with built in
data, fit, and customized defaults.
}
\examples{
library(survival)
library(dplyr)

data_lung <- lung \%>\%
  as_tibble() \%>\%
  mutate_at(vars(inst, status, sex), as.factor) \%>\%
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

row <- build_event_row_(
  Surv(time, status) ~ 1,
  data = data_lung,
  digits = 2
)

row(label = 'Age, years', col = 'age') \%>\%
row(label = 'Sex', col = 'sex') \%>\%
row(label = 'Institution', col = 'inst')
}
