% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.all.R
\name{sample.all}
\alias{sample.all}
\title{All Sampling Variations/Permutations}
\usage{
sample.all(n, size = n, replace = FALSE, prob = NULL)
}
\arguments{
\item{n}{Number of integers to sample from}

\item{size}{Length of the sample vectors}

\item{replace}{Logical value; if \code{FALSE} the sampling is without replacement; if \code{TRUE} the sampling is with replacement}

\item{prob}{Probability vector giving the sampling probability for each element (must be a probability vector with length \code{n})}
}
\value{
A matrix of all permutations of the elements \code{1, ..., n} (rows of the matrix give the permutations)
}
\description{
\code{sample.all} returns a matrix of all sampling variations/permutations from a set of integers
}
\details{
This function computes all sample vectors of size \code{size} composed of the elements \code{1, ..., n}, either with or without replacement
of elements.  If \code{size = n} and \code{replace = TRUE} then the list of all sample vectors corresponds to a list of all permutations of
the integers \code{1, ..., n}.
}
\examples{
sample.all(n = 4, replace = FALSE)
}
