% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utr_analysis.R
\name{getAltSequence}
\alias{getAltSequence}
\title{Check if Ref matches the actual sequence, if so then return altered sequence after replacing Ref with Alt. The sequence can have multiple fragments, only check the fragment which pos >= fragment_start & pos <= fragment_end}
\usage{
getAltSequence(seqTable, transcriptsTable, transcriptId, pos, ref, alt)
}
\arguments{
\item{seqTable}{sequences table containing columns: ensembl_transcript_id and seq. seq is the sequence of a seqType region: e.g. 5' UTR sequence or 3' UTR sequence. The seqTable is output from function getSeqTable.}

\item{transcriptId}{ensembl transcript id}

\item{ref}{nucleotides in Ref column}

\item{alt}{nucleotides in Alt column}

\item{trascriptsTable}{transcripts structure table, must have 4 columns: ensembl_transcript_id, start, end, strand.
start: start coordinate column in transcriptsTable for target region, for example "utr5_start", "utr3_start", or "genomic_coding_start"
end: end coordinate columns in transcriptsTable for target region, for example "utr5_end", "utr3_end", or "genomic_coding_end"
strand is the strand of the transcript.}
}
\value{
Altered sequence which combines all its fragments. If Ref doesn't match the actual sequence, raise error
}
\description{
Check if Ref matches the actual sequence, if so then return altered sequence after replacing Ref with Alt. The sequence can have multiple fragments, only check the fragment which pos >= fragment_start & pos <= fragment_end
}
\keyword{internal}
