% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Entropy and total variant incidence correlation plot}
\usage{
plot_correlation(
  df,
  host = 1,
  alpha = 1/3,
  line_dot_size = 3,
  base_size = 11,
  ylabel = "k-mer entropy (bits)\\n",
  xlabel = "\\nTotal variants (\%)",
  ymax = ceiling(max(df$entropy)),
  ybreak = 0.5
)
}
\arguments{
\item{df}{DiMA JSON converted csv file data}

\item{host}{number of host (1/2)}

\item{alpha}{any number from 0 (transparent) to 1 (opaque)}

\item{line_dot_size}{dot size in scatter plot}

\item{base_size}{base font size in plot}

\item{ylabel}{y-axis label}

\item{xlabel}{x-axis label}

\item{ymax}{maximum y-axis}

\item{ybreak}{y-axis breaks}
}
\value{
A scatter plot
}
\description{
This function plots the correlation between entropy and total variant incidence
of all the provided protein(s).
}
\examples{
plot_correlation(proteins_1host)
plot_correlation(protein_2hosts, base_size = 2, ybreak=1, ymax=10, host = 2)
}
