% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vicc.R
\name{vicc}
\alias{vicc}
\title{Varying Intraclass Correlation Coefficients}
\usage{
vicc(
  y,
  group,
  type = "pick_group",
  iter = 5000,
  chains = 2,
  burnin = 500,
  prior_scale = 1,
  prior_prob = 0.5
)
}
\arguments{
\item{y}{Numeric vector. The outcome variable.}

\item{group}{Numeric vector. The grouping variable (e.g., subjects). Note that the groups
must be numbered from 1 to the total number of groups.
See \code{\link[vICC]{change_group}}.}

\item{type}{Character string. Which model should be fitted
(defaults to \code{pick_group})? The options are
described in \code{Details}.}

\item{iter}{Numeric. The number of posterior samples per chain (excluding \code{burnin}).}

\item{chains}{Numeric. The number of chains (defaults to \code{2}).}

\item{burnin}{Numeric. The number of burnin samples, which are discarded
(defaults to \code{500}).}

\item{prior_scale}{Numeric. The prior distribution scale parameter
(defaults to \code{1}). Note the prior is a
half student-t distribution with 10 degrees of freedom.}

\item{prior_prob}{Numeric. The prior inclusion probability (defaults to \code{0.5}). This
is used for \code{type = "pick_tau"} or \code{type = "pick_group"} and ignored
otherwise.}
}
\value{
An object of class \code{vicc}.
}
\description{
Compute varying intraclass correlation coefficients with the method
             introduced in \insertCite{williams2019putting;textual}{vICC}.
}
\examples{
\donttest{

# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]

# fit model
fit <- vicc(y  = dat$rt,
            group = dat$id,
            iter = 250,
            burnin = 10,
            type =  "customary")
}
}
\references{
\insertAllCited{}
}
