% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_match_utils.R
\name{balance_summary}
\alias{balance_summary}
\title{Balance of Vaccinated/Unvaccinated Groups}
\usage{
balance_summary(
  data_set,
  nearest,
  exact,
  vacc_status_col,
  vaccinated_status,
  unvaccinated_status
)
}
\arguments{
\item{data_set}{\code{data.frame} to assess matching balance.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers).}

\item{exact}{Name(s) of column(s) for \code{exact} matching}

\item{vacc_status_col}{Name of the column containing the vaccination.}

\item{vaccinated_status}{Status assigned to the vaccinated population.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.}
}
\value{
Summary \code{data.frame} with the balance of each variable by
vaccine status. Numeric variables are reported with means, and
categorical/factor variables are reported with proportions.
In both cases, the Standardized Mean Difference (SMD) is calculated.
}
\description{
This function creates a summary after matching.
}
\keyword{internal}
