% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\alias{\%checkout\%}
\title{Validate objects}
\usage{
validate(., ..., .checklist = list(), .error_class = "validationError")

.f \%checkout\% .checks
}
\arguments{
\item{.}{Object to validate.}

\item{\dots}{Input-validation check formula(e).}

\item{.checklist}{List of check formulae. (These are combined with check
formulae provided via \code{\dots}.)}

\item{.error_class}{Subclass of the error condition to be raised when an
input validation error occurs (character).}

\item{.f}{Interpreted function, i.e., closure.}

\item{.checks}{List of check formulae, optionally containing a character
vector named \code{.error_class}, corresponding to the similarly named
argument.}
}
\description{
Validate objects
}
\examples{
\dontrun{
library(magrittr)

# Valid assertions: data frame returned (invisibly)
mtcars \%>\%
  validate(
    vld_all(~sapply(., is.numeric)),
    ~{nrow(.) > 10},
    vld_all(~c("mpg", "cyl") \%in\% names(.))
  )

# Invalid assertions: error raised
mtcars \%>\%
  validate(
    vld_all(~sapply(., is.numeric)),
    ~{nrow(.) > 1000},
    vld_all(~c("mpg", "cylinders") \%in\% names(.))
  )
}
}
