% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{.retry_key_get}
\alias{.retry_key_get}
\title{Internal helper function to retry reading a key from the system keyring.
This handles potential intermittent delays after writing to the keyring.}
\usage{
.retry_key_get(service, username, retries = 5, delay = 0.5)
}
\arguments{
\item{service}{Character. Keyring service name (e.g., "valdr_credentials").}

\item{username}{Character. Keyring username (e.g., "client_id").}

\item{retries}{Integer. Number of retry attempts before giving up (default 5).}

\item{delay}{Numeric. Delay in seconds between retry attempts (default 0.5).}
}
\value{
Character scalar. The retrieved credential value.
Will throw an error if unable to retrieve a valid, non-blank value after all retries.
}
\description{
Internal helper function to retry reading a key from the system keyring.
This handles potential intermittent delays after writing to the keyring.
}
