% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{get_nordbord_data}
\alias{get_nordbord_data}
\title{Get NordBord test data}
\usage{
get_nordbord_data(start_date = NULL, profile_id = NULL)
}
\arguments{
\item{start_date}{(Optional) A UTC ISO 8601 datetime string (e.g. "2025-06-25T00:00:00Z")
used to filter results by modification time. Input as a string.}

\item{profile_id}{(Optional) A specific profile ID to filter results for a single athlete. Input as a string.}
}
\value{
A data frame containing Profiles information and a data frame containing NordBord test data.
}
\description{
Wrapper around \code{get_nordbord_tests()} that also calls \code{get_profiles()}
to ensure profile data is available before retrieving NordBord test data.
Intended for use when you want to fetch Profiles information as well as NordBord tests from the API.
}
\examples{
\dontrun{
# Fetch all recent NordBord tests along with Profiles information
tests <- get_nordbord_data()
View(tests)

# Fetch NordBord tests for a specific profile
get_nordbord_data(profile_id = "abcd1234-ab12-cd34-ef56-abcdef123456")
}
}
