% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{is_linear_sequence}
\alias{is_linear_sequence}
\alias{is_linear_sequence.numeric}
\alias{is_linear_sequence.Date}
\alias{is_linear_sequence.POSIXct}
\alias{is_linear_sequence.character}
\alias{in_linear_sequence}
\alias{in_linear_sequence.character}
\alias{in_linear_sequence.numeric}
\alias{in_linear_sequence.Date}
\alias{in_linear_sequence.POSIXct}
\title{Check whether a variable represents a linear sequence}
\usage{
is_linear_sequence(x, by = NULL, ...)

\method{is_linear_sequence}{numeric}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  tol = 1e-08,
  ...
)

\method{is_linear_sequence}{Date}(x, by = NULL, begin = NULL, end = NULL, sort = TRUE, ...)

\method{is_linear_sequence}{POSIXct}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  tol = 1e-06,
  ...
)

\method{is_linear_sequence}{character}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  format = "auto",
  ...
)

in_linear_sequence(x, ...)

\method{in_linear_sequence}{character}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  format = "auto",
  ...
)

\method{in_linear_sequence}{numeric}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  tol = 1e-08,
  ...
)

\method{in_linear_sequence}{Date}(x, by = NULL, begin = NULL, end = NULL, sort = TRUE, ...)

\method{in_linear_sequence}{POSIXct}(
  x,
  by = NULL,
  begin = NULL,
  end = NULL,
  sort = TRUE,
  tol = 1e-06,
  ...
)
}
\arguments{
\item{x}{An R vector.}

\item{by}{bare (unquoted) variable name or a list of unquoted variable names, 
used to split \code{x} into groups. The check is executed for each group.}

\item{...}{Arguments passed to other methods.}

\item{begin}{Optionally, a value that should equal \code{min(x)}}

\item{end}{Optionally, a value that should equal \code{max(x)}}

\item{sort}{\code{[logical]}. When set to \code{TRUE}, \code{x}
is sorted within each group before testing.}

\item{tol}{numerical tolerance for gaps.}

\item{format}{\code{[character]}. How to interpret \code{x} as a time period.
Either \code{"auto"} for automatic detection or a specification passed to
\code{\link{strptime}}. Automatically detected periods are of the form year:
\code{"2020"}, yearMmonth: \code{"2020M01"},  yearQquarter: \code{"2020Q3"},
or year-Qquarter: \code{"2020-Q3"}.}
}
\value{
For \code{is_linear_sequence}: a single \code{TRUE} or \code{FALSE},
equal to \code{all(in_linear_sequence)}.

For \code{in_linear_sequence}: a \code{logical} vector with the same length as \code{x}.
}
\description{
A variable \eqn{X = (x_1, x_2,\ldots, x_n)} (\eqn{n\geq 0}) represents a
\emph{linear sequence} when \eqn{x_{j+1} - x_j} is constant for all
\eqn{j\geq 1}. That is,  elements in the series are equidistant and without
gaps.
}
\details{
Presence of a missing value (\code{NA}) in \code{x} will result in \code{NA},
except when \code{length(x) <= 2} and \code{start} and \code{end} are
\code{NULL}. Any sequence of length \eqn{\leq 2} is a linear sequence.
}
\examples{

is_linear_sequence(1:5) # TRUE
is_linear_sequence(c(1,3,5,4,2)) # FALSE
is_linear_sequence(c(1,3,5,4,2), sort=TRUE) # TRUE 
is_linear_sequence(NA_integer_) # TRUE
is_linear_sequence(NA_integer_, begin=4) # FALSE
is_linear_sequence(c(1, NA, 3)) # FALSE


d <- data.frame(
    number = c(pi, exp(1), 7)
  , date = as.Date(c("2015-12-17","2015-12-19","2015-12-21"))
  , time = as.POSIXct(c("2015-12-17","2015-12-19","2015-12-20"))
)

rules <- validator(
    is_linear_sequence(number)  # fails
  , is_linear_sequence(date)    # passes
  , is_linear_sequence(time)    # fails
)
summary(confront(d,rules))

## check groupwise data
dat <- data.frame(
   time = c(2012, 2013, 2012, 2013, 2015)
 , type = c("hi", "hi", "ha", "ha", "ha")
)
rule <- validator(in_linear_sequence(time, by=type))
values(confront(dat, rule)) ## 2xT, 3xF


rule <- validator(in_linear_sequence(time, type))
values( confront(dat, rule) )

}
\seealso{
Other cross-record-helpers: 
\code{\link{contains_exactly}()},
\code{\link{do_by}()},
\code{\link{exists_any}()},
\code{\link{hb}()},
\code{\link{hierarchy}()},
\code{\link{is_complete}()},
\code{\link{is_unique}()}
}
\concept{cross-record-helpers}
