% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{map5Lto3LInd}
\alias{map5Lto3LInd}
\title{Function to map EQ-5D-5L descriptive system to 3L index value}
\usage{
map5Lto3LInd(country = "UK", method = "CW", dimen, dimen2 = NA,
  dimen3 = NA, dimen4 = NA, dimen5 = NA)
}
\arguments{
\item{country}{default is "UK"}

\item{method}{CW cross walk}

\item{dimen}{response for EQ-5D-5L mobility  or the 5 digit response, or the vector of responses, e.g. 11111, c(1,1,1,1,1) or 1}

\item{dimen2}{response for EQ-5D-5L self care, or NA if the responses are given as dimen}

\item{dimen3}{response for EQ-5D-5L usual activities,or NA if the responses are given as dimen}

\item{dimen4}{response for EQ-5D-5L pain/discomfort, or NA if the responses are given as dimen}

\item{dimen5}{response for EQ-5D-5L anxiety/depression, or NA if the responses are given as dimen}
}
\value{
index value of EQ-5D-3L, -1 if any error
}
\description{
Function to map EQ-5D-5L descriptive system to 3L index value (ref:Van Hout et al 2012 and code inspired from https://github.com/brechtdv/eq5d-mapping)
}
\examples{
map5Lto3LInd("UK","CW",11125)
map5Lto3LInd("UK","CW",c(1,1,1,2,5))
map5Lto3LInd("UK","CW",1,1,1,2,5)
}
