% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\docType{data}
\name{names.backbone.atoms}
\alias{names.backbone.atoms}
\title{Backbone Atom Names}
\format{An object of class \code{character} of length 4.}
\usage{
names.backbone.atoms
}
\description{
Backbone atom names based on PDB atom naming conventions.
}
\details{
Protein backbone atom names based on the PDB atom naming
conventions.
\itemize{
\item \strong{N}: Nitrogen backbone atom; amide, "leading" functional group
\item \strong{CA}: alpha-Carbon backbone atom; bonds/connects the side chain to
the backbone
\item \strong{C}: Carbon backbone atom; carboxyl, "tail" functional group
\item \strong{O}: Oxygen backbone atom double bonded to the carbon backbone (C)
atom; part of the carboxyl, "tail" functional groups
}
}
\examples{
  names.backbone.atoms
  # [1] "N"  "CA" "C"  "O"

}
\seealso{
Other constants: \code{\link{names.polar.atoms}},
  \code{\link{names.res.AtomTypes}},
  \code{\link{names.resATs.carb.sulf}},
  \code{\link{names.resATs.nitro.neut}},
  \code{\link{names.resATs.nitro.pos}},
  \code{\link{names.resATs.oxy.neg}},
  \code{\link{names.resATs.oxy.neut}},
  \code{\link{names.residues}},
  \code{\link{names.sidechain.atoms}},
  \code{\link{names.waters}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\keyword{datasets}
