% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-info.R
\name{vapour_sds_names}
\alias{vapour_sds_names}
\title{GDAL raster subdatasets (variables)}
\usage{
vapour_sds_names(x)
}
\arguments{
\item{x}{a data source string, filename, database connection string, Thredds or other URL}
}
\value{
list of character vectors, see Details
}
\description{
A \strong{subdataset} is a collection abstraction for a number of \strong{variables}
within a single GDAL source. If there's only one variable the datasource and
the variable have the same data source string. If there is more than one the
subdatasets have the form \strong{DRIVER:"datasourcename":varname}. Each
subdataset name can stand in place of a data source name that has only one
variable, so we always treat a source as a subdataset, even if there's only
one.
}
\details{
Returns a list of \code{datasource} and \code{subdataset}. In the case of a normal data
source, with no subdatasets the value of both entries is the \code{datasource}.
}
\examples{
f <- system.file("extdata/gdal", "sds.nc", package = "vapour")
## protect from error with netcdf problems
result <- try(vapour_sds_names(f), silent = TRUE)
if (!inherits(result, "try-error")) {
  print(result)
}
vapour_sds_names(system.file("extdata", "sst.tif", package = "vapour"))
}
