% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightsChiBarSquare.R
\name{weightsChiBarSquare}
\alias{weightsChiBarSquare}
\title{Chi-bar-square weights computation}
\usage{
weightsChiBarSquare(cbs, control)
}
\arguments{
\item{cbs}{an object of class \code{\link{chiBarSquareObject}}, containing the parameters of the chi-bar-square distribution}

\item{control}{(optional) a list of control options for the computation of the chi-bar-weights}
}
\value{
A list containing the degrees of freedom of the chi-bar distributions involved in the chi-bar-square, along with
the associated weights.
}
\description{
Computation of the chi-bar-square weigths.
}
\details{
The function computes an approximation of the weights of the chi-bar-square distribution
\eqn{\bar{\chi}^2(I,C)} arising as the limiting distribution of the likelihood ratio test
statistics under the null hypothesis. More details can be found in the references listed below
}
\references{
Baey C, Cournède P-H, Kuhn E, 2019. Asymptotic distribution of likelihood ratio test
statistics for variance components in nonlinear mixed effects models. \emph{Computational
Statistics and Data Analysis} 135:107-122.

Silvapulle  MJ, Sen PK, 2011. Constrained statistical inference: order, inequality and shape constraints.
}
\author{
Charlotte Baey <\email{charlotte.baey@univ-lille.fr}>
}
