% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varTest.R
\name{varTest}
\alias{varTest}
\alias{test}
\alias{lrt}
\alias{likelihood}
\title{Variance component testing}
\usage{
varTest(
  m1,
  m0,
  control = list(M = 5000, parallel = T, nbcores = 1, B = 1000),
  pval.comp = "bounds",
  fim = "extract"
)
}
\arguments{
\item{m1}{a fit of the model under H1, obtained from \code{nlme}, \code{lme4}
or \code{saemix}}

\item{m0}{a fit of the model under H0, obtained from the same package as \code{m0}}

\item{control}{(optional) a list of control options for the computation of the chi-bar-weights}

\item{pval.comp}{(optional) the method to be used to compute the p-value, one of: \code{"bounds"} (the default),
\code{"approx"} or \code{"both"} (see Details section)}

\item{fim}{(optional) the method to compute the Fisher Information Matrix. Currently, only \code{fim="extract"} is supported.}
}
\value{
A list with the following components:
\item{\code{lrt}}{the likelihood ratio test statistics}
\item{\code{ddl}}{the degrees of freedom of the chi-bar distributions involved in the chi-bar-square distribution}
\item{\code{weights}}{the weights of the limiting chi-bar-square distribution}
\item{\code{pval}}{the p-value of the test}
}
\description{
Perform a likelihood ratio test to test whether a subset of the variances of the random effects
are equal to zero. The test is defined by two hypotheses, H0 and H1, and the model under H0 is
assumed to be nested within the model under H1.
}
\details{
It is possible to tests if any subset of the variances are equal to zero. However, the function does not
currently support nested random effects, and assumes that the random effects are Gaussian.

The asymptotic distribution of the likelihood ratio test is a chi-bar-square, with weights that need to be
approximated by Monte Carlo methods, apart from some specific cases where they are available explicitly. 
Therefore, the p-value of the test is not exact but approximated. This computation can be time-consuming, so
the default behaviour of the function is to provide bounds on the exact p-value, which can be enough in practice
to decide whether to reject or not the null hypothesis. This is triggered by the option \code{pval.comp="bounds"}.
To compute an approximation of the exact p-value, one should use the option \code{pval.comp="approx"} or \code{pval.comp="both"}.

When \code{pval.comp="approx"} or \code{pval.comp="both"}, the weights of th chi-bar-square distribution are computed and thus


The \code{control} argument controls the options for chi-bar-square weights computation. It is a list with the
following elements: \code{M} the size of the Monte Carlo simulation, \code{parallel} a boolean for parallel computing
and \code{nbcores} the number of cores to be used in case of parallel computing. Default is \code{M=5000}, \code{parallel=FALSE}
and \code{nbcores=1}.
}
\examples{
# load nlme package and example dataset
library(lme4)
data(Orthodont, package = "nlme")

# fit the two models under H1 and H0
lm1.h1.lme4 <- lmer(distance ~ 1 + Sex + age + age*Sex + 
(0 + age | Subject), data = Orthodont, REML = FALSE)
lm1.h0.lme4 <- lm(distance ~ 1 + Sex + age + age*Sex, data = Orthodont)

# compare them (order is important: m1 comes first)
varTest(lm1.h1.lme4,lm1.h0.lme4,pval.comp="bounds")

}
\references{
Baey C, Cournède P-H, Kuhn E, 2019. Asymptotic distribution of likelihood ratio test
statistics for variance components in nonlinear mixed effects models. \emph{Computational
Statistics and Data Analysis} 135:107-122.

Silvapulle  MJ, Sen PK, 2011. Constrained statistical inference: order, inequality and shape constraints.
}
\author{
Charlotte Baey <\email{charlotte.baey@univ-lille.fr}>
}
