% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmdcm_vb.R
\name{hmdcm_data_gen}
\alias{hmdcm_data_gen}
\title{the artificial data generation for the hidden-Markov DCM based on the given Q-matrix
\code{hmdcm_data_gen()} returns the artificially generated item response data for the HM-DCM}
\usage{
hmdcm_data_gen(
  I = 500,
  Q,
  min_theta = 0.2,
  max_theta = 0.8,
  att_cor = 0.7,
  seed = 17
)
}
\arguments{
\item{I}{the number of assumed respondents}

\item{Q}{the J by K binary matrix}

\item{min_theta}{the minimum value of the item parameter theta}

\item{max_theta}{the maximum value of the item parameter theta}

\item{att_cor}{the true value of the correlation among attributes (default: 0.1)}

\item{seed}{the seed value used for random number generation (default: 17)}
}
\value{
A list including:
\describe{
  \item{X}{the generated artificial item response data}
  \item{alpha_true}{the generated true vale of the attribute mastery pattern, matrix form}
  \item{alpha_patt_true}{the generated true vale of the attribute mastery pattern, string form}
}
}
\description{
the artificial data generation for the hidden-Markov DCM based on the given Q-matrix
\code{hmdcm_data_gen()} returns the artificially generated item response data for the HM-DCM
}
\examples{
indT = 3
Q = sim_Q_J30K3
hm_sim_Q = lapply(1:indT,function(time_point) Q)
hm_sim_data = hmdcm_data_gen(Q=hm_sim_Q,I=200)

}
\references{
Yamaguchi, K., & Martinez, A. J. (2023). Variational Bayes
inference for hidden Markov diagnostic classification models. \emph{British Journal
of Mathematical and Statistical Psychology}, 00, 1– 25. \doi{10.1111/bmsp.12308}
}
