% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.annovar.vcf.R
\name{run.annovar.vcf}
\alias{run.annovar.vcf}
\title{Run ANNOVAR on a VCF file}
\usage{
run.annovar.vcf(vcf.file, output.directory = NULL,
  output.filename = NULL, code.directory = NULL,
  log.directory = NULL, config.file = NULL, job.dependencies = NULL,
  job.group = NULL, job.name = NULL, isis = FALSE, quiet = FALSE,
  verify.options = !quiet)
}
\arguments{
\item{vcf.file}{Path to VCF file}

\item{output.directory}{Path to output directory}

\item{output.filename}{Name of resulting VCF file (defaults to SAMPLE_ID.vcf)}

\item{code.directory}{Path to directory where code should be stored}

\item{log.directory}{Path to directory where log files should be stored}

\item{config.file}{Path to config file}

\item{job.dependencies}{Vector with names of job dependencies}

\item{job.group}{Group job should belong to}

\item{job.name}{Name of job to be submitted}

\item{isis}{Logical indicating whether VCF files are from the isis (MiniSeq) variant caller}

\item{quiet}{Logical indicating whether to print command to screen rather than submit it to the system. Defaults to false, useful for debugging.}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\value{
None
}
\description{
Run ANNOVAR on a VCF file
}
