% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.vardict.sample.R
\name{run.vardict.sample}
\alias{run.vardict.sample}
\title{run.vardict.sample}
\usage{
run.vardict.sample(tumour.bam, sample.id, paired, proton = FALSE,
  normal.bam = NULL, output.directory = NULL, output.filename = NULL,
  code.directory = NULL, log.directory = NULL, config.file = NULL,
  job.dependencies = NULL, job.name = NULL, job.group = NULL,
  quiet = FALSE, verify.options = !quiet)
}
\arguments{
\item{tumour.bam}{Path to tumour sample BAM file.}

\item{sample.id}{Sample ID for labelling}

\item{paired}{Logical indicating whether to do variant calling with a matched normal.}

\item{proton}{Logical indicating whether the data was generated by proton sequencing. Defaults to False (i.e. Illumina)}

\item{normal.bam}{Path to normal BAM file if \code{paired = TRUE}}

\item{output.directory}{Path to output directory}

\item{output.filename}{Name of resulting VCF file (defaults to SAMPLE_ID.vcf)}

\item{code.directory}{Path to directory where code should be stored}

\item{log.directory}{Path to directory where log files should be stored}

\item{config.file}{Path to config file}

\item{job.dependencies}{Vector with names of job dependencies}

\item{job.name}{Name of job to be submitted}

\item{job.group}{Group job should belong to}

\item{quiet}{Logical indicating whether to print command to screen rather than submit it to the system. Defaults to false, useful for debugging.}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\description{
Run VarDict on a sample. Idea: have a low-level function that simply submits job to Perl, after BAM paths have been found. 
and output paths already have been decided upon
}
