% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.varitas.pipeline.R
\name{run.varitas.pipeline}
\alias{run.varitas.pipeline}
\title{Run VariTAS pipeline in full.}
\usage{
run.varitas.pipeline(file.details, output.directory, run.name = NULL,
  start.stage = c("alignment", "qc", "calling", "annotation", "merging"),
  variant.callers = NULL, proton = FALSE, quiet = FALSE,
  email = NULL, verify.options = !quiet,
  save.specification.files = !quiet)
}
\arguments{
\item{file.details}{Data frame containing details of files to be used during first processing step.
   Depending on what you want to be the first step in the pipeline, this can either be 
FASTQ files, BAM files, VCF files, or variant (txt) files.}

\item{output.directory}{Main directory where all files should be saved}

\item{run.name}{Name of pipeline run. Will be added as a prefix to all LSF jobs.}

\item{start.stage}{String indicating which stage pipeline should start at. If starting at a later stage
    of the pipeline, appropriate input files must be provided. For example, if starting with annotation, 
VCF files with variant calls must be provided.}

\item{variant.callers}{Vector specifying which variant callers should be run.}

\item{proton}{Logical indicating if data was generated by proton sequencing. Used to set base quality 
thresholds in variant calling steps.}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit jobs. Defaults to FALSE,
can be useful to set to TRUE for testing.}

\item{email}{Email address that should be notified when pipeline finishes. If NULL or FALSE, no email is sent.}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}

\item{save.specification.files}{Logical indicating if specification files should be saved to project directory}
}
\value{
None
}
\description{
Run all steps in VariTAS processing pipeline, with appropriate dependencies.
}
\examples{
run.varitas.pipeline(
       file.details = data.frame(
        sample.id = c('1', '2'),
        reads = c('1-R1.fastq.gz', '2-R1.fastq.gz'),
        mates = c('1-R2.fastq.gz', '2-R2.fastq.gz'),
         patient.id = c('P1', 'P1'),
         tissue = c('tumour', 'normal')
       ),
       output.directory = '.',
       quiet = TRUE,
       run.name = "Test", 
       variant.callers = c('mutect', 'varscan')
     )

}
