\name{plot.varcheck}

\alias{plot.varcheck}

\encoding{latin1}

\title{Plot method for objects of class varcheck}

\description{
  Time series plots of the residuals, their empirical distribution and
  ACFs/PACFs, as well as the ACFs/PACFs of the squared residuals. 
}

\usage{
\method{plot}{varcheck}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varcheck}}; generated by
    either \command{arch()}, \command{normality()} or \command{serial()}.}
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York. 
}

\seealso{
  \code{\link{arch}}, \code{\link{normality}}, \code{\link{serial}}
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
## ARCH test
archtest <- arch(var.2c)
plot(archtest)
## Normality test
normalitytest <- normality(var.2c)
plot(normalitytest)
## serial correlation test
serialtest <- serial(var.2c)
plot(serialtest)
}
}
\keyword{regression}
