"restrict" <-
function(x, method=c("ser", "manual"), thresh=2.0, resmat=NULL){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  method <- match.arg(method)
  thresh <- abs(thresh)
  K <- x$K
  p <- x$p
  datasub <- x$datamat[, -c(1 : K)]
  namesall <- colnames(datasub)
  yendog <- x$datamat[, c(1 : K)]
  sample <- x$obs
  ser <- function(x, y){
    tvals <- abs(coef(summary(x))[, 3])
    datares <- datasub
    while(min(tvals) < thresh){
      datares <- datares[, -1 * which.min(tvals)]
      lmres <- lm(y ~ -1 + ., data=datares)
      tvals <- abs(coef(summary(lmres))[, 3])     
      if(ncol(datares) == 1) {break}
    }
    return(list(lmres=lmres, datares=datares))
  }
  if(method=="ser"){
    x$restrictions <- matrix(0, nrow = K, ncol = ncol(datasub))
    colnames(x$restrictions) <- namesall
    rownames(x$restrictions) <- colnames(yendog)
    for(i in 1 : K){
      temp <- ser(x$varresult[[i]], yendog[, i])
      x$varresult[[i]] <- temp[[1]]
      namessub <- colnames(temp[[2]])
      x$restrictions[i, namesall%in%namessub] <- 1 
    }
  }else if(method=="manual"){
    resmat <- as.matrix(resmat)
    if(!(nrow(resmat) == K) | !(ncol(resmat) == ncol(datasub))){
      stop(paste("\n Please provide resmat with dimensions:", K, "x", ncol(datasub), "\n"))
    }
    x$restrictions <- resmat
    colnames(x$restrictions) <- namesall
    rownames(x$restrictions) <- colnames(yendog)
    for(i in 1 : K){
      datares <- datasub[, which(x$restrictions[i, ] == 1)]
      y <- yendog[, i]
      lmres <- lm(y ~ -1 + ., data=datares)
      x$varresult[[i]] <- lmres
    }
  }            
  return(x)
}
