% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_operator.R
\name{vault_client_operator}
\alias{vault_client_operator}
\title{Vault Administration}
\description{
Vault Administration

Vault Administration
}
\details{
Administration commands for vault operators.  Very few of these
commands should be used without consulting the vault documentation
as they affect the administration of a vault server, but they are
included here for completeness.
}
\examples{

server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()

  # Our test server is by default unsealed:
  client$status()$sealed

  # We can seal the vault to prevent all access:
  client$operator$seal()
  client$status()$sealed

  # And then unseal it again
  client$operator$unseal(server$keys)
  client$status()$sealed
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_operator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{vault_client_operator$new()}}
\item \href{#method-key_status}{\code{vault_client_operator$key_status()}}
\item \href{#method-is_initialized}{\code{vault_client_operator$is_initialized()}}
\item \href{#method-init}{\code{vault_client_operator$init()}}
\item \href{#method-leader_status}{\code{vault_client_operator$leader_status()}}
\item \href{#method-rekey_status}{\code{vault_client_operator$rekey_status()}}
\item \href{#method-rekey_start}{\code{vault_client_operator$rekey_start()}}
\item \href{#method-rekey_cancel}{\code{vault_client_operator$rekey_cancel()}}
\item \href{#method-rekey_submit}{\code{vault_client_operator$rekey_submit()}}
\item \href{#method-rotate}{\code{vault_client_operator$rotate()}}
\item \href{#method-seal}{\code{vault_client_operator$seal()}}
\item \href{#method-seal_status}{\code{vault_client_operator$seal_status()}}
\item \href{#method-unseal}{\code{vault_client_operator$unseal()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format">}\href{../../vaultr/html/vault_client_object.html#method-format}{\code{vaultr::vault_client_object$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help">}\href{../../vaultr/html/vault_client_object.html#method-help}{\code{vaultr::vault_client_object$help()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_operator} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-key_status"></a>}}
\if{latex}{\out{\hypertarget{method-key_status}{}}}
\subsection{Method \code{key_status()}}{
Return information about the current encryption
key of Vault.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$key_status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_initialized"></a>}}
\if{latex}{\out{\hypertarget{method-is_initialized}{}}}
\subsection{Method \code{is_initialized()}}{
Returns the initialization status of Vault
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$is_initialized()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init"></a>}}
\if{latex}{\out{\hypertarget{method-init}{}}}
\subsection{Method \code{init()}}{
This endpoint initializes a new Vault. The Vault
must not have been previously initialized.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$init(secret_shares, secret_threshold)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{secret_shares}}{Integer, specifying the number of shares
to split the master key into}

\item{\code{secret_threshold}}{Integer, specifying the number of
shares required to reconstruct the master key. This must be
less than or equal secret_shares}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-leader_status"></a>}}
\if{latex}{\out{\hypertarget{method-leader_status}{}}}
\subsection{Method \code{leader_status()}}{
Check the high availability status and current
leader of Vault
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$leader_status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rekey_status"></a>}}
\if{latex}{\out{\hypertarget{method-rekey_status}{}}}
\subsection{Method \code{rekey_status()}}{
Reads the configuration and progress of the
current rekey attempt
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$rekey_status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rekey_start"></a>}}
\if{latex}{\out{\hypertarget{method-rekey_start}{}}}
\subsection{Method \code{rekey_start()}}{
This method begins a new rekey attempt. Only a
single rekey attempt can take place at a time, and changing
the parameters of a rekey requires cancelling and starting a
new rekey, which will also provide a new nonce.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$rekey_start(secret_shares, secret_threshold)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{secret_shares}}{Integer, specifying the number of shares
to split the master key into}

\item{\code{secret_threshold}}{Integer, specifying the number of
shares required to reconstruct the master key. This must be
less than or equal secret_shares}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rekey_cancel"></a>}}
\if{latex}{\out{\hypertarget{method-rekey_cancel}{}}}
\subsection{Method \code{rekey_cancel()}}{
This method cancels any in-progress rekey. This
clears the rekey settings as well as any progress made. This
must be called to change the parameters of the rekey. Note
verification is still a part of a rekey. If rekeying is
cancelled during the verification flow, the current unseal
keys remain valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$rekey_cancel()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rekey_submit"></a>}}
\if{latex}{\out{\hypertarget{method-rekey_submit}{}}}
\subsection{Method \code{rekey_submit()}}{
This method is used to enter a single master key
share to progress the rekey of the Vault. If the threshold
number of master key shares is reached, Vault will complete
the rekey. Otherwise, this method must be called multiple
times until that threshold is met. The rekey nonce operation
must be provided with each call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$rekey_submit(key, nonce)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Specifies a single master share key (a string)}

\item{\code{nonce}}{Specifies the nonce of the rekey operation (a
string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
This method triggers a rotation of the backend
encryption key. This is the key that is used to encrypt data
written to the storage backend, and is not provided to
operators. This operation is done online. Future values are
encrypted with the new key, while old values are decrypted
with previous encryption keys.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$rotate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-seal"></a>}}
\if{latex}{\out{\hypertarget{method-seal}{}}}
\subsection{Method \code{seal()}}{
Seal the vault, preventing any access to it.
After the vault is sealed, it must be unsealed for further
use.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$seal()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-seal_status"></a>}}
\if{latex}{\out{\hypertarget{method-seal_status}{}}}
\subsection{Method \code{seal_status()}}{
Check the seal status of a Vault.  This method can
be used even when the client is not authenticated with the
vault (which will the case for a sealed vault).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$seal_status()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unseal"></a>}}
\if{latex}{\out{\hypertarget{method-unseal}{}}}
\subsection{Method \code{unseal()}}{
Submit a portion of a key to unseal the vault.
This method is typically called by multiple different
operators to assemble the master key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_operator$unseal(key, reset = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The master key share}

\item{\code{reset}}{Logical, indicating if the unseal process should
start be started again.}
}
\if{html}{\out{</div>}}
}
}
}
