% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale-continuous}
\alias{scale-continuous}
\alias{v_scale_x_continuous}
\alias{v_scale_y_continuous}
\alias{v_scale_x_log}
\alias{v_scale_y_log}
\title{Axis scale for continuous data}
\usage{
v_scale_x_continuous(
  vc,
  name = NULL,
  breaks = NULL,
  pretty = TRUE,
  labels = NULL,
  labels_tooltip = labels,
  zero = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "bottom"
)

v_scale_y_continuous(
  vc,
  name = NULL,
  breaks = NULL,
  pretty = TRUE,
  labels = NULL,
  labels_tooltip = labels,
  zero = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "left"
)

v_scale_x_log(
  vc,
  name = NULL,
  breaks = NULL,
  pretty = TRUE,
  labels = NULL,
  labels_tooltip = labels,
  zero = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "bottom"
)

v_scale_y_log(
  vc,
  name = NULL,
  breaks = NULL,
  pretty = TRUE,
  labels = NULL,
  labels_tooltip = labels,
  zero = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "left"
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}} or specific chart's type function.}

\item{name}{Title for the axis.}

\item{breaks}{One of:
\itemize{
\item A single \code{numeric} value giving the number of breaks.
\item A numeric vector of positions.
}}

\item{pretty}{Use \code{\link[=pretty]{pretty()}} to identify breaks if \code{breaks} is a single numeric value.}

\item{labels, labels_tooltip}{The format to be applied on numeric in the labels/tooltip. Either:
\itemize{
\item A single character indicating the D3 format.
\item A \code{JS} function, such as \code{\link[=format_num_d3]{format_num_d3()}}.
}}

\item{zero}{Force axis to start at 0.}

\item{min}{Minimum value on the axis.}

\item{max}{Maximum value on the axis.}

\item{...}{Additional parameters for the axis.}

\item{position}{Position of the axis.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Axis scale for continuous data
}
\examples{

library(vchartr)

# Add a title to the axis
vchart(top_generation) \%>\%
  v_bar(aes(country, electricity_generation)) \%>\%
  v_scale_y_continuous(name = "Electricity generation")

vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source)) \%>\%
  v_scale_y_continuous(name = "Electricity generation")

# Specify number of breaks
vchart(top_generation) \%>\%
  v_bar(aes(country, electricity_generation)) \%>\%
  v_scale_y_continuous(breaks = 10)

# Specify breaks position
vchart(top_generation) \%>\%
  v_bar(aes(country, electricity_generation)) \%>\%
  v_scale_y_continuous(breaks = c(0, 5000, 10000))

# Format labels
vchart(top_generation) \%>\%
  v_bar(aes(country, electricity_generation)) \%>\%
  v_scale_y_continuous(labels = "~s")

# Format labels with options
vchart(top_generation) \%>\%
  v_bar(aes(country, electricity_generation)) \%>\%
  v_scale_y_continuous(labels = format_num_d3(",", suffix = " TWh", locale = "fr-FR"))

vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source)) \%>\%
  v_scale_y_continuous(labels = format_num_d3(",", suffix = " TWh", locale = "fr-FR"))

}
