% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_boxplot}
\alias{v_boxplot}
\title{Create a BoxPlot}
\usage{
v_boxplot(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  outliers = TRUE,
  args_outliers = NULL,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Arguments passed to \href{https://www.visactor.io/vchart/option/boxPlotChart}{JavaScript methods}.}

\item{outliers}{Display or not outliers.}

\item{args_outliers}{Arguments passed to \code{\link[=v_scatter]{v_scatter()}}.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a BoxPlot
}
\examples{

library(vchartr)

data("penguins", package = "palmerpenguins")

vchart(penguins) \%>\% 
  v_boxplot(aes(species, flipper_length_mm))

vchart(penguins) \%>\% 
  v_boxplot(aes(species, flipper_length_mm, color = sex))


data("mpg", package = "ggplot2")

vchart(mpg) \%>\% 
  v_boxplot(aes(as.character(year), hwy))

vchart(mpg) \%>\% 
  v_boxplot(aes(class, hwy))

vchart(mpg) \%>\% 
  v_boxplot(aes(class, hwy, color = as.character(year)))
}
