% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_hist}
\alias{v_hist}
\title{Create an Histogram}
\usage{
v_hist(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  stack = FALSE,
  bins = 30,
  binwidth = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{stack}{Whether to stack the data or not (if \code{fill} aesthetic is provided).}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{...}{Additional properties for histogram bars.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create an Histogram
}
\examples{

library(vchartr)
library(palmerpenguins)

# Create an histogram using a numeric variable
vchart(penguins) \%>\%
  v_hist(aes(flipper_length_mm))

# Customize some style properties
vchart(penguins) \%>\%
  v_hist(
    aes(flipper_length_mm),
    bar = list(
      style = list(
        stroke = "white",
        line_width = 1,
        fill = "forestgreen"
      )
    )
  )

# Use fill aesthetic to differentiate series
vchart(penguins) \%>\%
  v_hist(aes(flipper_length_mm, fill = species))

# Stack results
vchart(penguins) \%>\%
  v_hist(aes(flipper_length_mm, fill = species), stack = TRUE)

# Use custom colors
vchart(penguins) \%>\%
  v_hist(
    aes(flipper_length_mm, fill = species),
    bar = list(
      style = list(opacity = 0.5)
    )
  ) \%>\%
  v_scale_color_manual(c(
    Adelie = "#ffa232",
    Chinstrap = "#33a2a2",
    Gentoo = "#b34df2"
  ))

}
