% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.stdmean2}
\alias{meta.lc.stdmean2}
\title{Confidence interval for a linear contrast of standardized mean
differences from 2-group studies}
\usage{
meta.lc.stdmean2(alpha, m1, m2, sd1, sd2, n1, n2, v, stdzr)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of sample means for group 1}

\item{m2}{vector of sample means for group 2}

\item{sd1}{vector of sample SDs for group 1}

\item{sd2}{vector of sample SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{v}{vector of contrast coefficients}

\item{stdzr}{\itemize{
\item set to 0 for square root average variance standardizer
\item set to 1 for group 1 SD standardizer
\item set to 2 for group 2 SD standardizer
\item set to 3 for square root weighted variance standardizer
}}
}
\value{
Returns 1-row matrix with the estimate for the contrast. The matrix
has the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of 2-group standardized mean differences from two or
more studies. Equal variances within or across studies is not assumed.
Use the square root average variance standardizer (stdzr = 0) for 2-group
experimental designs.  Use the square root weighted variance standardizer
(stdzr = 3) for 2-group nonexperimental designs with simple random sampling.
The stdzr = 1 and stdzr = 2 options can be used with either 2-group experimental
or nonexperimental designs.
}
\examples{
m1 <- c(45.1, 39.2, 36.3, 34.5)
m2 <- c(30.0, 35.1, 35.3, 36.2)
sd1 <- c(10.7, 10.5, 9.4, 11.5)
sd2 <- c(12.3, 12.0, 10.4, 9.6)
n1 <- c(40, 20, 50, 25)
n2 <- c(40, 20, 48, 26)
v <- c(.5, .5, -.5, -.5)
meta.lc.stdmean2(.05, m1, m2, sd1, sd2, n1, n2, v, 0)

# Should return: 
#           Estimate        SE        LL       UL
# Contrast 0.8557914 0.2709192 0.3247995 1.386783


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
