% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.mean1}
\alias{meta.lc.mean1}
\title{Confidence interval a for a linear contrast of means}
\usage{
meta.lc.mean1(alpha, m, sd, n, v, eqvar = FALSE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated means}

\item{sd}{vector of estimated standard deviations}

\item{n}{vector of sample sizes}

\item{v}{vector of contrast coefficients}

\item{eqvar}{\itemize{
\item FALSE for unequal variance method
\item TRUE for equal variance method
}}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of means from two or more studies. This function will
use either an unequal variance (recommended) or an equal variance method.
A Satterthwaite adjustment to the degrees of freedom is used with the
unequal variance method.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
n <- c(10, 10, 10, 10)
v <- c(.5, .5, -.5, -.5)
meta.lc.mean1(.05, m, sd, n, v, eqvar = FALSE)

# Should return:
#          Estimate       SE        LL        UL       df
# Contrast    -5.35 1.300136 -7.993583 -2.706417 33.52169

}
\references{
\insertRef{Snedecor1980}{vcmeta}
}
