% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{data}
\name{UnhandledHTTPRequestError}
\alias{UnhandledHTTPRequestError}
\title{UnhandledHTTPRequestError}
\arguments{
\item{request}{a request}

\item{cassette}{a cassette, the current cassette}
}
\description{
UnhandledHTTPRequestError
}
\details{
How this error class is used:
If \code{record="once"} we trigger this.

Users can use vcr in the context of both use_cassette
and insert_cassette.

For the former, all requests go through the call_block
But for the latter, requests go through webmockr

Where is one place where we can put UnhandledHTTPRequestError
that will handle both use_cassette and insert_cassette?
}
\section{Error situations where this is invoked}{

\itemize{
\item record=once AND there's a new request that doesn't match
the one in the cassette on disk
\itemize{
\item in webmockr: if no stub found and there are recorded
interactions on the cassette, and record = once, then
error with UnhandledHTTPRequestError
\itemize{
\item but if record != once, then allow it, unless record == none
}
}
\item others?
}
}

\examples{
vcr_configure(dir = tempdir())
cassettes()
insert_cassette("turtle")
request <- Request$new("post", 'https://eu.httpbin.org/post?a=5',
  "", list(foo = "bar"))

err <- UnhandledHTTPRequestError$new(request)
err$request_description()
err$current_matchers()
err$match_request_on_headers()
err$match_request_on_body()
err$formatted_headers()
cat(err$formatted_headers(), "\\n")
cat(err$cassettes_description(), "\\n")
cat(err$cassettes_list(), "\\n")
err$formatted_suggestions()
cat(err$format_bullet_point('foo bar', 1), "\\n")
err$suggestion_for("use_new_episodes")
err$suggestions()
err$no_cassette_suggestions()
err$record_mode_suggestion()
err$has_used_interaction_matching()
err$match_requests_on_suggestion()

# err$construct_message()

# cleanup
unlink(tempdir())
}
\keyword{datasets}
