% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persisters-file.R
\docType{data}
\name{FileSystem}
\alias{FileSystem}
\title{File system persister}
\arguments{
\item{file_name}{(character) Just the file name, not whole path}

\item{content}{(character) content to record to a cassette}

\item{path}{(character) Storage directory for cassettes}

\item{write2disk}{(logical) write to disk or just make a new FileSystem
object. Default: \code{FALSE}}
}
\description{
File system persister
}
\details{
The only built-in cassette persister. Persists cassettes
to the file system.

\strong{Methods}
\describe{
\item{\code{get_cassette(file_name = NULL, content = NULL, path = NULL)}}{
Gets the cassette for the given storage key (file name).
}
\item{\code{set_cassette(file_name = NULL, content)}}{
Sets the cassette for the given storage key (file name).
}
\item{\code{is_empty()}}{
Checks if a cassette is empty or not. Returns boolean
}
}
\strong{Private Methods}
\describe{
\item{\code{storage_location()}}{
Get storage location
}
\item{\code{absolute_path_to_file()}}{
Get absolute path to the \code{storage_location}
}
}
}
\examples{
\dontrun{
vcr_configure(dir = tempdir())

(yy <- FileSystem$new(file_name = "file4014931b21b.yml"))
yy$set_cassette(content = "hello world!")

# is empty?
yy$is_empty()

# get cassette
yy$get_cassette(file_name = "file4014931b21b.yml")

# clenaup
unlink(file.path(tempdir(), "file4014931b21b.yml"))
}
}
\keyword{internal}
