% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{vec_ptype}
\alias{vec_ptype}
\alias{vec_ptype_common}
\alias{vec_ptype_show}
\title{Find the prototype of a set of vectors}
\usage{
vec_ptype(x)

vec_ptype_common(..., .ptype = NULL)

vec_ptype_show(...)
}
\arguments{
\item{..., x}{Vectors inputs}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}
}
\value{
\code{vec_ptype()} and \code{vec_ptype_common()} return a prototype
(a size-0 vector)
}
\description{
\code{vec_ptype()} finds the prototype of a single vector.
\code{vec_ptype_common()} finds the common type of multiple vectors.
\code{vec_ptype_show()} nicely prints the common type of any number of
inputs, and is designed for interactive exploration.
}
\details{
\code{vec_ptype_common()} first finds the prototype of each input, then
successively calls \code{\link[=vec_ptype2]{vec_ptype2()}} to find a common type.
}
\section{Prototype}{

A prototype is \link[=vec_size]{size} 0 vector containing attributes, but no
data. Generally, this is just \code{vec_slice(x, 0L)}, but some inputs
require special handling.

For example, the prototype of logical vectors that only contain missing
values is the special \link{unspecified} type, which can be coerced to any
other 1d type. This allows bare \code{NA}s to represent missing values for
any 1d vector type.
}

\section{The prototype of \code{NULL}}{


In general we treat \code{NULL} as an absence of argument (which is
often an error). In the case of \code{vec_ptype()} and
\code{vec_ptype_common()}, we have chosen \code{NULL} as the identity of the
common type monoid: the common type of \code{foo} and \code{NULL} is always
\code{foo}. For this reason, the prototype of \code{NULL} is \code{NULL}.
}

\examples{
# Unknown types ------------------------------------------
vec_ptype_show()
vec_ptype_show(NA)
vec_ptype_show(NULL)

# Vectors ------------------------------------------------
vec_ptype_show(1:10)
vec_ptype_show(letters)
vec_ptype_show(TRUE)

vec_ptype_show(Sys.Date())
vec_ptype_show(Sys.time())
vec_ptype_show(factor("a"))
vec_ptype_show(ordered("a"))

# Matrices -----------------------------------------------
# The prototype of a matrix includes the number of columns
vec_ptype_show(array(1, dim = c(1, 2)))
vec_ptype_show(array("x", dim = c(1, 2)))

# Data frames --------------------------------------------
# The prototype of a data frame includes the prototype of
# every column
vec_ptype_show(iris)

# The prototype of multiple data frames includes the prototype
# of every column that in any data frame
vec_ptype_show(
  data.frame(x = TRUE),
  data.frame(y = 2),
  data.frame(z = "a")
)
}
