% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-data-frame.R, R/type-tibble.R
\name{df_ptype2}
\alias{df_ptype2}
\alias{df_cast}
\alias{tib_ptype2}
\alias{tib_cast}
\title{Coercion between two data frames}
\usage{
df_ptype2(x, y, ..., x_arg = "", y_arg = "")

df_cast(x, to, ..., x_arg = "", to_arg = "")

tib_ptype2(x, y, ..., x_arg = "", y_arg = "")

tib_cast(x, to, ..., x_arg = "", to_arg = "")
}
\arguments{
\item{x, y, to}{Subclasses of data frame.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{to_arg}{Argument names for \code{x} and \code{to}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\value{
\itemize{
\item When \code{x} and \code{y} are not compatible, an error of class
\code{vctrs_error_incompatible_type} is thrown.
\item When \code{x} and \code{y} are compatible, \code{df_ptype2()} returns the common
type as a bare data frame. \code{tib_ptype2()} returns the common type
as a bare tibble.
}
}
\description{
\code{df_ptype2()} and \code{df_cast()} are the two functions you need to
call from \code{vec_ptype2()} and \code{vec_cast()} methods for data frame
subclasses. See \link[=howto-faq-coercion-data-frame]{?howto-faq-coercion-data-frame}.
Their main job is to determine the common type of two data frames,
adding and coercing columns as needed, or throwing an incompatible
type error when the columns are not compatible.
}
