% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAbundanceAnomaly.R
\name{getAbundanceAnomaly}
\alias{getAbundanceAnomaly}
\title{Get Abundance Anomaly}
\usage{
getAbundanceAnomaly(
  collections,
  interval,
  target_year,
  agency = NULL,
  species = NULL,
  trap = NULL,
  sex = "female",
  trapnight_min = 1,
  trapnight_max = NULL,
  separate_by = NULL
)
}
\arguments{
\item{collections}{Collections data retrieved from `getArthroCollections()`}

\item{interval}{Calculation interval for abundance, accepts “collection_date”,“Biweek”,“Week”, and “Month}

\item{target_year}{Year to calculate analysis on. Collections data must have a year range of at least (target_year - 5, target_year)}

\item{agency}{An optional vector for filtering agency by character code}

\item{species}{An optional vector for filtering species. Species_display_name is the accepted notation.To see a list of species present in your data run unique(collections$species_display_name). If species is unspecified, the default NULL will return data for all species in data.}

\item{trap}{An optional vector for filtering trap type by acronym. Trap_acronym is the is the accepted notation. Run unique(collections$trap_acronym) to see trap types present in your data. If trap is unspecified, the default NULL will return data for all trap types.}

\item{sex}{An optional vector for filtering sex type. Accepts 'male', 'female',or 'other'. If sex is unspecified, the default NULL will return data for female sex.}

\item{trapnight_min}{Minimum trap night restriction for calculation. Default is 1.}

\item{trapnight_max}{Maximum trap night restriction for calculation. Default is no restriction.}

\item{separate_by}{Separate/group the calculation by 'trap','species' or 'agency'. Default NULL does not separate.}
}
\value{
Abundance anomaly calculation
}
\description{
`getAbundanceAnomaly(...) `requires at least five years prior to the target_year of arthro collections data to calculate for the specified parameters. The function uses the methods of the Gateway Abundance Anomaly calculator, and will not work if there is fewer than five years of data present.
}
\examples{
getAbundanceAnomaly(sample_collections,"Biweek",target_year=2020, species="Cx pipiens")

}
\keyword{abundance}
