% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-setters.R
\name{shiny-setters}
\alias{shiny-setters}
\alias{vw_shiny_set_signal}
\alias{vw_shiny_set_data}
\alias{vw_shiny_run}
\title{Set information in a Vega chart from Shiny}
\usage{
vw_shiny_set_signal(outputId, name, value, run = TRUE, ...)

vw_shiny_set_data(outputId, name, value, run = TRUE, ...)

vw_shiny_run(outputId, value, ...)
}
\arguments{
\item{outputId}{\code{character}, shiny \code{outputId} for the vegawidget}

\item{name}{\code{character}, name of the signal or dataset being set,
as defined in the vegaspec}

\item{value}{reactive expression, e.g. \code{input$slider} or \code{dataset()},
that returns the value to which to set the signal or dataset}

\item{run}{\code{logical} indicates if the chart is to be run immediately}

\item{...}{other arguments passed on to \code{\link[shiny:observeEvent]{shiny::observeEvent()}}}
}
\value{
\code{\link[shiny:observeEvent]{shiny::observeEvent()}} function that responds to changes in the
reactive-expression \code{value}
}
\description{
There are two ways to change a Vega chart: by setting
a \emph{signal} or by setting a \emph{dataset}; you can also
direct a Vega chart to re-run itself. Any signal or
dataset you set must first be defined and \strong{named} in the vegaspec.
These functions are called from within
a Shiny \code{server()} function, where they act like
\code{\link[shiny:observe]{shiny::observe()}} or \code{\link[shiny:observeEvent]{shiny::observeEvent()}}.
}
\details{
To see these functions in action, you can run a shiny-demo:
\itemize{
\item \code{vw_shiny_set_signal()}: call \code{vw_shiny_demo("signal-set-get")}
\item \code{vw_shiny_set_data()}: call \code{vw_shiny_demo("data-set-get")}
\item \code{vw_shiny_run()}: call \code{vw_shiny_demo("data-set-swap-run")}
}

For the signal and data setters, in addition to the chart \code{outputId},
you will need to provide:
\itemize{
\item the \code{name} of the signal or dataset you wish to keep updated
\item the \code{value} to which you want to set the signal or dataset;
this should be a reactive expression like \code{input$slider} or \code{rct_dataset()}
\item whether or not you want to \code{run} the Vega view again immediately
after setting this value
}

If you do not set \code{run = TRUE} in the setter-function,
you can use the \code{vw_shiny_run()} function to control when
the chart re-runs. One possibility is to set its \code{value} to a reactive
expression that refers to, for example, a \code{\link[shiny:actionButton]{shiny::actionButton()}}.
}
