% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.R
\name{Extract}
\alias{Extract}
\alias{$}
\alias{$,vegtable-method}
\alias{$<-,vegtable,ANY-method}
\alias{$<-}
\alias{$<-,vegtable-method}
\alias{$,coverconvert-method}
\alias{$<-,coverconvert,list-method}
\alias{[,vegtable,ANY,ANY-method}
\alias{[}
\alias{[,vegtable,ANY,ANY,ANY-method}
\alias{[<-,vegtable,ANY,ANY,ANY-method}
\alias{[<-}
\alias{[<-,vegtable-method}
\title{Select or replace elements in objects}
\usage{
\S4method{$}{vegtable}(x, name)

\S4method{$}{vegtable,ANY}(x, name) <- value

\S4method{$}{coverconvert}(x, name)

\S4method{$}{coverconvert,list}(x, name) <- value

\S4method{[}{vegtable,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{vegtable,ANY,ANY,ANY}(x, i, j) <- value
}
\arguments{
\item{x}{Object of class \linkS4class{vegtable}.}

\item{name}{A name to access.}

\item{value}{Either a vectors or a list, used as replacement.}

\item{i, j}{Indices for access.}

\item{...}{Further arguments passed to or from other methods.}

\item{drop}{A logical value passed to \link{Extract}.}
}
\description{
Methods for quick access to slot \code{header} of \linkS4class{vegtable} objects or for
access to single cover scales in \linkS4class{coverconvert} objects.
Also replacement methods are implemented.
}
\examples{
## Range of latitude values in database
range(Kenya_veg$LATITUDE)

## Summary of countries
summary(Kenya_veg$COUNTRY)
summary(droplevels(Kenya_veg$COUNTRY))

## First 5 samples
summary(Kenya_veg[1:5,])

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
