% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/used_synonyms.R
\name{used_synonyms}
\alias{used_synonyms}
\alias{used_synonyms,vegtable-method}
\title{Retrieve synonyms used in the data set}
\usage{
used_synonyms(x, ...)

\S4method{used_synonyms}{vegtable}(x, ...)
}
\arguments{
\item{x}{A \linkS4class{vegtable} object.}

\item{...}{Further arguments to be passed from or to another methods.}
}
\value{
A data frame with following columns:
\describe{
\item{SynonymsID}{Usage ID of synonyms.}
\item{Synonym}{The synonym itself.}
\item{SynonymAuthor}{Author of synonym.}
\item{TaxonConceptID}{ID of the taxon concept.}
\item{AcceptedNameID}{Usage ID of the accepted name.}
\item{AcceptedName}{The respective accepted name.}
\item{AcceptedNameAuthor}{The author of the accepted name.}
}
}
\description{
Plots records are rather linked to plant names than plant taxon concepts.
This function provides a quick report about synonyms used in a data set (a
\linkS4class{vegtable} object) and their respective accepted name.

This function will only retrieve synonyms that are used in plot records.
}
\examples{
## Synonyms used in the Kenya_veg
Synonyms <- used_synonyms(Kenya_veg)
head(Synonyms)

}
\seealso{
\code{\link[=accepted_name]{accepted_name()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
