% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_fun.R
\name{ef_fun}
\alias{ef_fun}
\title{Experimental: Returns a function of Emission Factor by age of use}
\usage{
ef_fun(ef, type = "logistic", x = 1:length(ef), x0 = mean(ef), k = 1/4,
  L = max(ef))
}
\arguments{
\item{ef}{Numeric; numeric vector of emission factors.}

\item{type}{Character; "logistic"  by default so far.}

\item{x}{Numeric; vector for ages of use.}

\item{x0}{Numeric;  the x-value of the sigmoid's midpoint,}

\item{k}{Numeric; the steepness of the curve.}

\item{L}{Integer; the curve's maximum value.}
}
\value{
dataframe of age distrubution of vehicles at each street.
}
\description{
\code{\link{ef_fun}} returns amount of vehicles at each age
}
\examples{
{
data(fe2015)
CO <- vein::EmissionFactors(fe2015[fe2015$Pollutant == "CO", 11])
ef_logit <- ef_fun(ef = CO, x0 = 27, k = 0.4, L = 33)
plot(ef_logit, type = "b", pch = 16)
lines(ef_logit, pch = 16, col = "blue")
}
}
\references{
https://en.wikipedia.org/wiki/Logistic_function
}
