% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_emfac.R
\name{ef_emfac}
\alias{ef_emfac}
\title{Emission Factors from EMFAC emission factors}
\usage{
ef_emfac(
  efpath,
  dg = 750,
  dd = 850,
  dhy = 750,
  dcng = 0.8,
  fill_missing = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{efpath}{Character path to EMFAC ef (g/miles)}

\item{dg}{Numeric density of gasoline, default 750 kg/m3}

\item{dd}{Numeric density of diesel, default 850 kg/m3}

\item{dhy}{Numeric density of hybrids, default 750 kg/m3}

\item{dcng}{Numeric density of CNG, default 0.8 kg/m3}

\item{fill_missing}{Logical to fill and correct ef = 0}

\item{verbose}{Logical, to show more information}
}
\value{
data.table with emission estimation in long format
}
\description{
\code{\link{ef_emfac}} reads path to ef EMFAC.
You must download the
emission factors from EMFAC website.
}
\note{
Fuel consumption must be present
}
\examples{
\dontrun{
# do not run
}
}
