% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbalise.R
\name{verbalise}
\alias{verbalise}
\title{Describe a pairwise relationship}
\usage{
verbalise(x, ids = leaves(x))
}
\arguments{
\item{x}{A \code{ped} object, or a list of such.}

\item{ids}{A vector containing the names of two pedigree members.}
}
\value{
An object of class \code{pairrel}. This is essentially a list of lists,
where each inner list describes a single path.
}
\description{
The description includes all pedigree paths between the two individuals,
indicating with brackets the topmost common ancestors in each path.
}
\examples{

# Example 1: Family quartet

x = nuclearPed(2)
verbalise(x, 1:2)
verbalise(x, 2:3)
verbalise(x, 3:4)

# Example 2: Complicated cousin pedigree

y = doubleCousins(degree1 = 1, removal1 = 1, half1 = TRUE,
                  degree2 = 2, removal2 = 0, half2 = FALSE)
verbalise(y)

# Example 3: Full sib mating

z = fullSibMating(1)
verbalise(z)
verbalise(z, ids = c(1,5))

# Example 4: Quad half first cousins

w = quadHalfFirstCousins()
verbalise(w)

}
