% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_scene.R
\name{sample_scene}
\alias{sample_scene}
\title{Recenters and subsets a 3D scene for visibility estimates}
\usage{
sample_scene(data, scene_radius, scene_shape, center, downsample, messages)
}
\arguments{
\item{data}{LAS class object containing the xyx coordinates of a 3D
point cloud.}

\item{scene_radius}{numerical. The radius of the final scene. Can refer to
the radius of a sphere if \code{scene_shape = "sph"} or of a circle
if \code{scene_shape = "circ"}.}

\item{scene_shape}{character string. Defines the shape of the scene: "sph" and
"circ" are accepted (see details for more informations). Default = "circ".}

\item{center}{(optional) vector of length 3 providing the xyz coordinates of
the user defined animal location. If not provided, the user can manually select
the animal location in the 3D point cloud. The average coordinates of the selected
region will be set as the animal location (see details).}

\item{downsample}{numeric. Enables the user to downsample the point cloud before
visualizing it for scene center manual selection (if no \code{center} is
provided). Defines the voxel resolution within which a single point of the
input scene will be kept.
\code{downsample = 0} desable downsampling. Default is 0 if the scene contains less
than 5e6 surveyed points or 0.1 if the scene contains more than 5e6 surveyed points.}

\item{messages}{logical. Disables the messages and message box when manually
selecting the scene center.}
}
\value{
A LAS class object containing the coordinates of the reshaped scene.
}
\description{
Recenters and if needed subsets a 3D scan image  for use in the
\code{\link{visibility}} function. Keeps the points that fall within a user
defined distance from the animal location and recenters the scene so that the
animal location in the output point has 0,0,0 coordinates. The animal location can
be defined by providing xyz coordinates or can be manually selected within the scene.
The scene shape can be spherical or circular (see details for more information).
}
\details{
\subsection{Scene shape}{if \code{scene_shape = "circ"} the distance
to scene center is computed in the xy dimension of the original scene only,
resulting in a circular scene. If \code{scene_shape = "sph"}
the distance to the scene center is similar to arguments \code{scene.radius}
in \code{\link{visibility}} function and \code{cut_off} in
\code{\link{viewsheds}}.}
\subsection{Manual selection of scene center}{ if no \code{center} is
provided, a 3D plot automatically opens. The user can navigate around the
surveyed points (rotate = left
click, pan = right click) and select points (in a rectangular region)
with the middle click. Once the points are selected, a message box opens
(if not disabled). If the user clicks "yes", the plot window closes and the
average point coordinates are defined as the animal location. If the user clicks
"no", he/she can revise the previous selection.}
}
\examples{

#- import the tree_line_plot dataset
file <- system.file("extdata", "tree_line_plot.laz", package="viewshed3d")
tls  <-  lidR::readLAS(file,select="xyz")

#- define the animal location
center <- c(0,-6,1)

#- reshape the TLS scene with scene_shape="circ" and the calculated center
reshaped <- viewshed3d::sample_scene(tls,scene_radius = 4,
                                     center=center,
                                     scene_shape = "circ")

lidR::plot(reshaped)

#- reshape the TLS scene with scene_shape="sph" and the calculated center
reshaped <- viewshed3d::sample_scene(tls,scene_radius = 4,
                                     center=center,
                                     scene_shape = "sph")

lidR::plot(reshaped)

if (interactive()){
#- manual selection of the center
reshaped <- viewshed3d::sample_scene(tls,scene_radius = 4,
                                     scene_shape = "circ")

lidR::plot(reshaped)
}

}
