% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_drecno.R
\name{get_drecno}
\alias{get_drecno}
\title{Get DrecNo from drug names or MedicinalProd_Id}
\usage{
get_drecno(
  d_sel,
  mp,
  allow_combination = TRUE,
  method = c("drug_name", "mpi_list"),
  verbose = TRUE,
  show_all = deprecated(),
  inspect = deprecated()
)
}
\arguments{
\item{d_sel}{A named list. Selection of drug names or medicinalprod_id. See details}

\item{mp}{A modified MP data.table. See \code{\link{mp_}}}

\item{allow_combination}{A logical. Should fixed associations including the drug of interest be retrieved? See details.}

\item{method}{Should DrecNo be found from drug names or from MedicinalProd_Id?}

\item{verbose}{A logical. Allows you to see matching drug names in the console.
Turn to FALSE once you've checked the matching.}

\item{show_all}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}  Use \code{verbose} instead.}

\item{inspect}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{verbose} instead.}
}
\value{
A named list of integers. DrecNos.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect
Drug Record Numbers associated to one or more drugs.
}
\details{
\code{get_drecno()} is an \emph{ID collector} function.
Collected IDs can be used to create drug columns in datasets
like \code{demo}, \code{link}, etc. (see \code{vignette("basic_workflow")})
}
\section{Argument \code{verbose}}{


The \code{verbose} argument is here to let you check
the result of \code{get_drecno()}. This is an important step in your
project setup: You must ensure that the drugs you are looking for
are correctly matched.
}

\section{Argument \code{d_sel}}{


\code{d_sel} must be a named list of character vectors.
To learn why, see \code{vignette("basic_workflow")}.
Names of \code{d_sel} are automatically lowered and trimed.
}

\section{Matching drugs}{


With "drug_name" method, either exact match or perl regex
match can be used. The latter
is built upon lookarounds to ensure that a string does not match to
composite drug names including the string,
i.e. \verb{trastuzumab emtasine} for \code{trastuzumab}, or close names
like \code{alitretinoin} when looking for \code{tretinoin}.

Exact match is used for "mpi_list" method.
}

\section{Choosing a method}{


"drug_name" let you work with drug names. It's likely to be
the appropriate method in most of the cases.

"mpi_list" is used when you have a list of MedicinalProd_Ids.
A drug can have multiple MedicinalProd_Ids, corresponding to
different packagings. The MedicinalProd_Id matching is typically used to identify DrecNo(s)
contained in an ATC class (extracted from \code{thg}), since not all MPI of drugs are present in \code{thg} (explanations in \code{\link[=get_atc_code]{get_atc_code()}}).
}

\section{WHO names}{


WHO names are attributed to drugs by... the WHO.
A drug only has one WHO name, but can have multiple
international nonproprietary names (e.g. "tretinoin" and
"all-trans retinoic acid").

You should use WHO names to ensure proper identification of
drugs and DrecNos, especially if you work with combinations.
}

\section{Argument \code{allow_combination}}{


Fixed associations of drugs refers to specialty containing
more than one active ingredient (for example,
acetylsalicylic acid and clopidogrel).
In VigiLyze, the default is \strong{NOT} to account for
these fixed associations. For example, when you
call "acetylsalicylic acid" in VigiLyze, you don't have the cases
reported with the fixed-association "acetylsalicylic acid; clopidogrel"
\strong{unless the substances were distinctly coded by the reporter.}
Here, the default is to find a drug even if it is prescribed in a fixed association.
Importantly, when retrieving fixed-association drugs, the non-of-interest
drug alone drecno is not found, hence the cases related to this drug will not be added to those of the drug of interest.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# ## Get drecnos for a list a drugs. Check spelling and use WHO name,
# in lowercase

d_sel_names <- list(
  nivolumab = "nivolumab",
  ipilimumab = "ipilimumab",
  nivo_ipi = c("nivolumab", "ipilimumab")
  )

# Read mp with get_drecno(), to identify drugs without combinations

# Take the time to read the matching drugs. Did you forget a drug?

d_drecno <-
  get_drecno(d_sel_names,
             mp = mp_,
             allow_combination = FALSE,
             method = "drug_name")
d_drecno

# And DrecNos of drugs allowing for combinations

d_drecno <-
  get_drecno(d_sel = d_sel_names,
             mp = mp_,
             allow_combination = TRUE,
             method = "drug_name")
d_drecno
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=add_drug]{add_drug()}}, \code{\link[=get_atc_code]{get_atc_code()}}
}
\keyword{atc}
\keyword{data_management}
\keyword{drug}
