% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spvim_ics.R
\name{spvim_ics}
\alias{spvim_ics}
\title{Influence function estimates for SPVIMs}
\usage{
spvim_ics(Z, z_counts, W, v, psi, G, c_n, ics, measure)
}
\arguments{
\item{Z}{the matrix of presence/absence of each feature (columns) in each sampled subset (rows)}

\item{z_counts}{the number of times each unique subset was sampled}

\item{W}{the matrix of weights}

\item{v}{the estimated predictiveness measures}

\item{psi}{the estimated SPVIM values}

\item{G}{the constraint matrix}

\item{c_n}{the constraint values}

\item{ics}{a matrix of influence function values for each predictiveness measure}

\item{measure}{the type of measure (e.g., "r_squared" or "auc")}
}
\value{
a named list of length 2; \code{contrib_v} is the contribution from estimating V, while \code{contrib_s} is the contribution from sampling subsets.
}
\description{
Compute the influence functions for the contribution from sampling observations and subsets.
}
\details{
The processes for sampling observations and sampling subsets are independent. Thus, we can compute the influence function separately for each sampling process. For further details, see the paper by Williamson and Feng (2020).
}
